/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;

public interface PersistExecutor<C> {
    public void persist(Iterable<? extends C> var1);

    default public void persist(C ... entities) {
        this.persist(Arrays.asSet((Object[])entities));
    }

    public static <C, I> PersistExecutor<C> forPersister(ConfiguredPersister<C, I> persister) {
        IdentifierInsertionManager<C, I> identifierInsertionManager = persister.getMapping().getIdMapping().getIdentifierInsertionManager();
        if (identifierInsertionManager instanceof AlreadyAssignedIdentifierManager && ((AlreadyAssignedIdentifierManager)identifierInsertionManager).getIsPersistedFunction() == null) {
            return new AlreadyAssignedIdentifierPersistExecutor<C, I>(persister);
        }
        return new DefaultPersistExecutor<C, I>(persister);
    }

    public static class DefaultPersistExecutor<C, I>
    implements PersistExecutor<C> {
        protected final EntityPersister<C, I> persister;

        public DefaultPersistExecutor(EntityPersister<C, I> persister) {
            this.persister = persister;
        }

        @Override
        public void persist(Iterable<? extends C> entities) {
            this.persist(entities, new DefaultIsNewDeterminer<C>(){

                @Override
                public boolean isNew(C c) {
                    return persister.isNew(c);
                }
            }, this.persister, this.persister, this.persister, (Function<C, I>)((Function<Object, Object>)this.persister::getId));
        }

        protected void persist(Iterable<? extends C> entities, NewEntitiesCollector<C> isNewProvider, SelectExecutor<C, I> selector, UpdateExecutor<C> updater, InsertExecutor<C> inserter, Function<C, I> idProvider) {
            if (Iterables.isEmpty(entities)) {
                return;
            }
            Set<C> toInsert = isNewProvider.collectNewEntities(entities);
            Set toUpdate = Iterables.minus((Collection)Iterables.asList(entities), toInsert);
            if (!toInsert.isEmpty()) {
                inserter.insert(toInsert);
            }
            if (!toUpdate.isEmpty()) {
                Map existingEntitiesPerId = Iterables.map(selector.select(Iterables.collect((Iterable)toUpdate, idProvider, HashSet::new)), idProvider);
                Map modifiedEntitiesPerId = Iterables.map((Iterable)toUpdate, idProvider);
                Map modifiedVSunmodified = Maps.innerJoin((Map)modifiedEntitiesPerId, (Map)existingEntitiesPerId);
                Set updateArg = (Set)Iterables.collect(modifiedVSunmodified.entrySet(), entry -> new Duo(entry.getKey(), entry.getValue()), LinkedHashSet::new);
                updater.update(updateArg, true);
            }
        }

        public static abstract class DefaultIsNewDeterminer<T>
        implements NewEntitiesCollector<T> {
            @Override
            public Set<T> collectNewEntities(Iterable<? extends T> entities) {
                return Iterables.stream(entities).filter(this::isNew).collect(Collectors.toSet());
            }

            public abstract boolean isNew(T var1);
        }

        public static interface NewEntitiesCollector<T> {
            public Set<T> collectNewEntities(Iterable<? extends T> var1);
        }
    }

    public static class AlreadyAssignedIdentifierPersistExecutor<C, I>
    implements PersistExecutor<C> {
        protected final EntityPersister<C, I> persister;

        public AlreadyAssignedIdentifierPersistExecutor(EntityPersister<C, I> persister) {
            this.persister = persister;
        }

        @Override
        public void persist(Iterable<? extends C> entities) {
            this.persist(entities, this.persister, this.persister, this.persister, (Function<C, I>)((Function<Object, Object>)this.persister::getId));
        }

        protected void persist(Iterable<? extends C> entities, SelectExecutor<C, I> selector, UpdateExecutor<C> updater, InsertExecutor<C> inserter, Function<C, I> idProvider) {
            if (Iterables.isEmpty(entities)) {
                return;
            }
            Map existingEntitiesPerId = Iterables.map(selector.select(Iterables.collect(entities, idProvider, HashSet::new)), idProvider);
            Map modifiedEntitiesPerId = Iterables.stream(entities).filter(c -> existingEntitiesPerId.containsKey(idProvider.apply(c))).collect(Collectors.toMap(idProvider, Function.identity(), (k1, k2) -> k1));
            Collection toUpdate = modifiedEntitiesPerId.values();
            Collection toInsert = Iterables.stream(entities).filter(c -> !existingEntitiesPerId.containsKey(idProvider.apply(c))).collect(Collectors.toSet());
            if (!toInsert.isEmpty()) {
                inserter.insert(toInsert);
            }
            if (!toUpdate.isEmpty()) {
                Map modifiedVSunmodified = Maps.innerJoin(modifiedEntitiesPerId, (Map)existingEntitiesPerId);
                Set updateArg = (Set)Iterables.collect(modifiedVSunmodified.entrySet(), entry -> new Duo(entry.getKey(), entry.getValue()), LinkedHashSet::new);
                updater.update(updateArg, true);
            }
        }
    }
}

